define('april-fools:lib/april-fools', [], function () {
    console.log('AprilFools: Script loaded successfully.');

    // Wait for DOM to be ready
    function initPrank() {
        if (!document.body) {
            console.log('AprilFools: DOM not ready, retrying...');
            setTimeout(initPrank, 100);
            return;
        }

        const today = new Date();
        const isAprilFools = today.getMonth() === 3 && today.getDate() === 1;

        if (!isAprilFools) {
            console.log('AprilFools: Not April 1st, skipping.');
            return;
        }

        const dismissedFlip = localStorage.getItem('aprilFoolsFlipDismissedAt');
        const dismissedEmojis = localStorage.getItem('aprilFoolsEmojisDismissedAt');
        const todayStr = today.toDateString();

        if (dismissedEmojis && new Date(parseInt(dismissedEmojis)).toDateString() === todayStr) {
            console.log('AprilFools: Fully dismissed today, skipping.');
            return;
        }

        console.log('AprilFools: Activating prank!');
        activatePrank(!!dismissedFlip && new Date(parseInt(dismissedFlip)).toDateString() === todayStr);
    }

    function activatePrank(isFlipDismissed) {
        let flipActive = !isFlipDismissed;
        let emojiInterval;
        const emojiElements = [];

        // Flip screen if not dismissed
        if (flipActive) {
            const flipStyle = document.createElement('style');
            flipStyle.id = 'april-fools-flip';
            flipStyle.textContent = `
                body {
                    transform: rotate(180deg);
                    transition: transform 1s ease;
                }
            `;
            document.head.appendChild(flipStyle);
        }

        // Add rainbow background
        const rainbowStyle = document.createElement('style');
        rainbowStyle.id = 'april-fools-rainbow';
        rainbowStyle.textContent = `
            body {
                background: linear-gradient(45deg, red, orange, yellow, green, blue, indigo, violet);
                animation: rainbowShift 5s infinite;
            }
            @keyframes rainbowShift {
                0% { background-position: 0% 50%; }
                50% { background-position: 100% 50%; }
                100% { background-position: 0% 50%; }
            }
        `;
        document.head.appendChild(rainbowStyle);

        // Add prank message
        const message = document.createElement('div');
        message.id = 'april-fools-message';
        message.textContent = flipActive 
            ? 'Happy April Fools! Press ESC or reload to unflip!' 
            : 'Press ESC or reload again to remove emojis!';
        message.style.position = 'fixed';
        message.style.top = '50%';
        message.style.left = '50%';
        message.style.transform = flipActive ? 'translate(-50%, -50%) rotate(180deg)' : 'translate(-50%, -50%)';
        message.style.fontSize = '40px';
        message.style.fontFamily = 'Comic Sans MS, cursive';
        message.style.color = '#fff';
        message.style.textShadow = '2px 2px 4px #000';
        message.style.zIndex = '10000';
        message.style.background = 'rgba(0, 0, 0, 0.7)';
        message.style.padding = '20px';
        message.style.borderRadius = '10px';
        document.body.appendChild(message);

        // Add animated emojis
        const emojis = ['😂', '🤣', '🤪', '🥳', '🎉', '🎊', '😜', '🤡', '🦄', '🌈'];

        for (let i = 0; i < 20; i++) {
            createEmoji();
        }

        emojiInterval = setInterval(() => {
            createEmoji();
            if (emojiElements.length > 30) {
                const oldestEmoji = emojiElements.shift();
                if (oldestEmoji && oldestEmoji.parentNode) {
                    oldestEmoji.parentNode.removeChild(oldestEmoji);
                }
            }
        }, 2000);

        function createEmoji() {
            const emoji = document.createElement('div');
            const randomEmoji = emojis[Math.floor(Math.random() * emojis.length)];

            emoji.textContent = randomEmoji;
            emoji.style.position = 'fixed';
            emoji.style.fontSize = Math.floor(Math.random() * 30 + 20) + 'px';
            emoji.style.left = Math.floor(Math.random() * 100) + '%';
            emoji.style.top = Math.floor(Math.random() * 100) + '%';
            emoji.style.zIndex = '9999';
            emoji.style.pointerEvents = 'none';
            emoji.style.userSelect = 'none';
            emoji.style.animation = 'emoji-float 10s ease-in-out infinite';
            emoji.classList.add('april-fools-emoji');

            if (!document.getElementById('april-fools-animations')) {
                const animStyle = document.createElement('style');
                animStyle.id = 'april-fools-animations';
                animStyle.textContent = `
                    @keyframes emoji-float {
                        0% { transform: translate(0, 0) rotate(0deg); }
                        25% { transform: translate(${Math.random() * 100 - 50}px, ${Math.random() * 100 - 50}px) rotate(${Math.random() * 30}deg); }
                        50% { transform: translate(${Math.random() * 100 - 50}px, ${Math.random() * 100 - 50}px) rotate(${Math.random() * 60}deg); }
                        75% { transform: translate(${Math.random() * 100 - 50}px, ${Math.random() * 100 - 50}px) rotate(${Math.random() * 30}deg); }
                        100% { transform: translate(0, 0) rotate(0deg); }
                    }
                `;
                document.head.appendChild(animStyle);
            }

            document.body.appendChild(emoji);
            emojiElements.push(emoji);
        }

        // Handle deactivation (ESC or reload)
        function deactivate(event) {
            const today = new Date().toDateString();

            if (flipActive) {
                // First ESC/reload: Remove flip
                console.log('AprilFools: Deactivating flip.');
                const flipStyle = document.getElementById('april-fools-flip');
                if (flipStyle) document.head.removeChild(flipStyle);
                flipActive = false;
                message.textContent = 'Press ESC or reload again to remove emojis!';
                message.style.transform = 'translate(-50%, -50%)';
                localStorage.setItem('aprilFoolsFlipDismissedAt', Date.now().toString());
            } else {
                // Second ESC/reload: Remove everything
                console.log('AprilFools: Deactivating emojis and all effects.');
                document.head.removeChild(rainbowStyle);
                document.body.removeChild(message);
                emojiElements.forEach(emoji => {
                    if (emoji.parentNode) emoji.parentNode.removeChild(emoji);
                });
                emojiElements.length = 0;
                clearInterval(emojiInterval);
                const animStyle = document.getElementById('april-fools-animations');
                if (animStyle) animStyle.parentNode.removeChild(animStyle);
                localStorage.setItem('aprilFoolsEmojisDismissedAt', Date.now().toString());
                document.removeEventListener('keydown', deactivate);
            }
        }

        // Bind ESC key
        document.addEventListener('keydown', (e) => {
            if (e.key === 'Escape') deactivate(e);
        });

        // Handle reloads via visibility change (mobile workaround)
        document.addEventListener('visibilitychange', () => {
            if (document.visibilityState === 'visible') {
                const flipDismissed = localStorage.getItem('aprilFoolsFlipDismissedAt');
                const emojisDismissed = localStorage.getItem('aprilFoolsEmojisDismissedAt');
                const todayStr = new Date().toDateString();

                if (!flipDismissed || new Date(parseInt(flipDismissed)).toDateString() !== todayStr) {
                    // First reload: Treat as first ESC
                    deactivate();
                } else if (!emojisDismissed || new Date(parseInt(emojisDismissed)).toDateString() !== todayStr) {
                    // Second reload: Treat as second ESC
                    deactivate();
                }
            }
        });
    }

    // Start the prank when DOM is ready
    initPrank();
});
