<?php

use Espo\Core\{
    Container,
    DataManager,
};
use Espo\Core\InjectableFactory;
use Espo\Core\Utils\Config;
use Espo\Core\Utils\Config\ConfigWriter;

class AfterInstall
{
    private const TAB_LIST_ENTITIES = [];
    private const DEFAULT_CONFIG = [];

    private Config $config;
    private ConfigWriter $configWriter;
    private DataManager $dataManager;

    public function run(Container $container, array $params = []): void
    {
        $this->loadDependencies($container);

        if (empty($params['isUpgrade'])) {
            $this->addEntitiesToTabList();
        }

        $this->defaultConfig();

        $this->clearCache();
    }

    private function loadDependencies(Container $container): void
    {
        $injectableFactory = $container->getByClass(InjectableFactory::class);

        $this->config = $container->getByClass(Config::class);
        $this->configWriter = $injectableFactory->create(ConfigWriter::class);
        $this->dataManager = $container->getByClass(DataManager::class);
    }

    private function defaultConfig(): void
    {
        foreach (self::DEFAULT_CONFIG as $key => $value) {
            if (!$this->config->has($key)) {
                $this->configWriter->set($key, $value);
            }
        }

        $this->configWriter->save();
    }

    private function addEntitiesToTabList(): void
    {
        $tabList = $this->config->get('tabList') ?? [];

        foreach (self::TAB_LIST_ENTITIES as $entity) {
            if (!in_array($entity, $tabList, true)) {
                $tabList[] = $entity;
            }
        }

        $this->configWriter->set('tabList', $tabList);
        $this->configWriter->save();
    }

    private function clearCache(): void
    {
        try {
            $this->dataManager->clearCache();
        } catch (\Exception) {
        }
    }
}
