Espo.define('lark-show-all-fields:views/record/show-all-fields', 'views/modal', function (Dep) {
    return Dep.extend({

        sortBy: 'name',
        sortDirection: 'asc',
        onlyValues: false,
        filter: "",
        template: 'lark-show-all-fields:modals/show-all-fields',
        events: {
            'click a.sort': 'onSortClick',
            'click input#values': 'onOnlyValuesClick',
            'input input#filter': 'onFilter'
        },

        onFilter: function (e) {
            this.debounceHandleInputChange();
        },

        onOnlyValuesClick: function (e) {
            var $i = $(e.currentTarget);
            this.onlyValues = $i.is(':checked');
            this.render();
        },

        onSortClick: function (e) {
            var $a = $(e.currentTarget);
            var field = $a.data('sort');

            if (this.sortBy === field) {
                this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
            } else {
                this.sortBy = field;
                this.sortDirection = 'desc';
            }

            this.render();
        },

        data() {
            const self = this;
            const d = [];
            const filterValue = this.filter && this.filter.length > 0 ? this.filter.trim() : null;
            for (const [fieldName, fieldDef] of this.fieldEntries) {
                const fieldType = fieldDef.type || 'base';
                const fieldLabel = this.translate(fieldName, 'fields', this.options.model.name);
                let rawValue = this.fieldAttributes[fieldType == "link" ? fieldName+"Name" : fieldName];
                if (this.onlyValues && (rawValue === null || rawValue === '' || typeof rawValue === 'undefined')) {
                    continue;
                }
                
                if (fieldName == "teams")
                    rawValue = this.options.model.getTeamIdList();
                else if (fieldType == "linkMultiple")
                    rawValue = this.options.model.getLinkMultipleIdList(fieldName);

                if (filterValue != null)
                {
                    const regex = new RegExp(filterValue, 'i');
                    if (!regex.test(fieldLabel) && !regex.test(fieldName) && !regex.test(rawValue) && !regex.test(fieldType))
                    {
                        continue;
                    } 
                }

                d.push({name: fieldName, label: fieldLabel, type: fieldType, value: rawValue});
            }

            var sorted = _.sortBy(d || [], function (item) {
                var v = item[self.sortBy];

                if (v === null || typeof v === 'undefined') return '';
                if (_.isNumber(v)) return v;
                return String(v).toLowerCase();
            });

            if (this.sortDirection === 'desc') sorted.reverse();

            return {
                fields: sorted,
                sortUp: this.sortDirection === 'asc', 
                sortByName: this.sortBy == 'name',
                sortByLabel: this.sortBy == 'label',
                sortByValue: this.sortBy == 'value',
                sortByType: this.sortBy == 'type', 
                onlyValues: this.onlyValues};
        },
        render: function () {
            this.filter = $('#filter').val();
            Dep.prototype.render.call(this);
        },
        afterRender: function () {
            Dep.prototype.afterRender.call(this);
            setTimeout(() => {
                const el = $('#filter');
                if (el.length > 0)
                {
                    if (this.filter && this.filter.length > 0)
                        el.val(this.filter)

                    el.focus();
                };
            }, 100);
        },
        setup() {
            Dep.prototype.setup.call(this);

            this.debounceHandleInputChange = _.debounce(this.render, 500);

            const entityType = this.options.model.name;
            const fields = this.getMetadata().get(['entityDefs', entityType, 'fields']) || {};
            this.fieldAttributes = this.options.model.attributes;

            this.fieldEntries = Object.entries(fields).sort(([a], [b]) => a.localeCompare(b));
            this.sortDirection = 'asc';
            this.sortLabel = false;

            this.buttonList = [
                {
                    name: 'close',
                    text: "Close",
                    style: 'primary',
                    onClick: () => this.close(),
                }
            ];
        }
    });
});