Espo.define(['view'], function (Dep) {
    return Dep.extend({

        templateContent: '<a style="color:rgb(180,106,102)" role="button" data-action="maintenance" title="Rebuild and Reload"><span class="icon fas fa-wrench"></span></a>',

        setup: function () {
            const self = this;
            Dep.prototype.setup.call(this);
            this.addActionHandler('maintenance', (e, element) => {
                e.preventDefault();
                self.doMaintenance();
            }); 
        },

        doMaintenance: function () {
            Espo.Ui.notify('Running maintenance…', 'neutral');

            Espo.Ajax.postRequest('Admin/rebuild')
                .then(() => {
                    window.location.reload(true);
                    Espo.Ui.notify('Maintenance completed successfully.', 'success');
                })
                .catch((err) => {
                    Espo.Ui.notify('Error during rebuild: ' + err.message, 'error');
                });
        }
    });
});